@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
@endpush
@section('content')

<section class="destination-details">
    <div class="container">
        <div class="destination-details-title-box">
            <div class="destination-details-title">
                <h3>{{$package->name}}</h3>
            </div>
            <div class="destination-details-review">
                <div class="destination-details-review-text">
                    <span><i class="fa-regular fa-location-dot"></i>
                        {{$package->destination->name}}
                    </span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class=" row packageImage">
                    <div class="col-lg-8">
                        <div class="destination-details-left-image">
                            <div class="image">
                                <img src="{{loadFile($package->image->path)}}" alt="{{$package->name}}">
                            </div>
                            @isset($package->video)
                            <div class="destination-details-gallery">
                                <a href="{{$package->video}}" target="__blank" class="btn-2 video-link"><i
                                        class="fa-thin fa-video"></i> Video
                                    <span></span></a>
                            </div>
                            @endisset
                        </div>
                    </div>
                    <div class="col-lg-4 image">
                        @if ($package->images->isNotEmpty())
                        @php
                            $images = $package->images->skip(1);
                            $featuredImage = $images->first();
                            $galleryImages = $images->skip(1)->take(2);
                        @endphp
                        <div class="imageRight">
                            {{-- Featured Image --}}
                            <div class="destination-details-right-image">
                                <a href="{{loadFile($featuredImage->path)}}" class="lightbox-image"
                                    data-fancybox="gallery">
                                    <img src="{{loadFile($featuredImage->path)}}" alt="{{$package->name}}">
                                </a>
                            </div>

                            {{-- Gallery Images --}}
                            @if($galleryImages->isNotEmpty())
                            <div class="row g-3 mt-3">
                                @foreach($galleryImages as $image)
                                <div class="col-lg-6 col-md-6">
                                    <div class="destination-details-right-image wow fadeInLeft" data-wow-delay="100ms">
                                        <a href="{{loadFile($image->path)}}" class="lightbox-image"
                                            data-fancybox="gallery">
                                            <img src="{{loadFile($image->path)}}" alt="{{$package->name}}">
                                        </a>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="destination-details-content">
                    <h5 class="destination-details-common-title">
                        @lang('app.description')
                    </h5>
                    <p>
                        {!! $package->description !!}
                    </p>
                </div>
                <div class="row">
                    @if (!empty($package->inclusions))
                    <div class="col-lg-4 col-12">
                        <div class="destination-details-price">
                            <div class="price-content">
                                <h6>@lang('app.price_includes')</h6>
                                <ul>
                                    @forelse ($package->inclusions as $include)
                                        <li><i class="fa-light fa-check"></i>{{$include}}</li>
                                    @empty
                                        <li><i class="fa-light fa-check"></i>Jeurney Cost</li>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if (!empty($package->exclusions))
                    <div class="col-lg-4 col-12">
                        <div class="destination-details-price">
                            <div class="price-content">
                                <h6>@lang('app.price_excludes')</h6>
                                <ul>
                                    @forelse ($package->exclusions as $exclude)
                                        <li><i class="fa-sharp fa-light fa-xmark"></i>{{$exclude}}</li>
                                    @empty
                                        <li><i class="fa-sharp fa-light fa-xmark"></i>Cost</li>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if (!empty($package->we_expect))
                    <div class="col-lg-4 col-12">
                        <div class="destination-details-price">
                            <div class="price-content">
                                <h6>@lang('app.what_we_want')</h6>
                                <ul>
                                    @forelse ($package->we_expect as $expect)
                                        <li><i class="fa-light fa-check"></i>{{$expect}}</li>
                                    @empty
                                        <li><i class="fa-light fa-check"></i>Jeurney Cost</li>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="col-xl-9 col-lg-11">
                        <div class="destination-details-facilities">
                            <ul>
                                <li><i class="fa-thin fa-clock"></i> {{str()->lower($package->duration)}} </li>
                                <li>
                                    <i class="fa-thin fa-user"></i> @lang("app.max_travelers") : {{$package->max_people}}
                                </li>
                                <li>
                                    <i class="fa-thin fa-user"></i> @lang("app.min_travelers") : {{$package->min_people}}
                                </li>
                                <li>
                                    <i class="fa-thin fa-list"></i> @lang("app.package_type") : {{$package->category->name}}
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="destination-details-meeting">
                    <h5 class="destination-details-common-title">@lang('app.meeting_and_pickup')</h5>
                    <div class="destination-details-meeting-inner">
                        <div class="destination-details-meeting-content">
                            <h6>@lang("app.start_point")</h6>
                            <p>{{$package->start_point}}</p>
                            <a target="__blank" href="https://www.google.com/maps?q={{$package->start_point}}">Open
                                in Google Maps</a>

                        </div>
                        <div class="destination-details-meeting-content">
                            <h6>@lang('start_date')</h6>
                            <p>{{ $package->start_date->format('d M, Y') }}</p>
                        </div>
                        <div class="destination-details-meeting-content">
                            <h6>@lang("end_point")</h6>
                            <p>{{$package->end_point}}</p>
                            <a target="__blank" href="https://www.google.com/maps?q={{$package->end_point}}">Open
                                in Google Maps {{$package->id}} </a>
                        </div>
                    </div>
                </div>
                <div class="py-5 reviews">
                    <x-frontend.reviews :package="$package" />
                </div>
            </div>

            <div class="col-lg-4">
                <div class="destination-details-right-container">
                    <div class="destination-details-price-form wow fadeInUp" data-wow-delay="100ms">
                        <h5 class="destination-details-right-title">@lang('app.price_list')</h5>

                        <p><i class="fa-thin fa-user"></i> @lang('app.adult') <span>৳{{$package->adult_price}}</span></p>
                        <p><i class="fa-thin fa-user-alt"></i> @lang('app.child') <span>৳{{$package->child_price}}</span></p>
                        <p><i class="fa-thin fa-user-construction"></i> @lang('app.infant') <span>৳{{$package->infant_price}}</span></p>
                        @if ($availableSeats > 0)
                        <x-frontend.booking.form :availableSeats="$availableSeats" :package="$package"/>
                        @else
                        <div class="alert alert-danger my-3">
                            @lang('app.no_seats_available')
                        </div>
                        @endif

                        {{-- <div class="wish-list">
                            <p><i class="fa-thin fa-heart"></i> 1 Time saved to wishlist</p>
                            <p><i class="fa-thin fa-eye"></i> 89</p>
                        </div> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

